<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Anuncio extends Model
{
    protected $table = 'anuncios';
    protected $primaryKey = 'id_anuncio';
    public $timestamps = false;

    protected $fillable = [
        'titulo',
        'contenido',
        'plan_estudio_id',
        'activo'
    ];

    public function planEstudio()
    {
        return $this->belongsTo(PlanEstudio::class, 'plan_estudio_id');
    }
}
