<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Docente extends Model
{
    use HasFactory;

    protected $table = 'docentes';

    protected $fillable = [
        'usuario_id',
        'nombre',
        'apellido',
        'dni',
        'email',
        'telefono',
        'direccion',
        'departamento',
        'cargo',
    ];

    public function cursos()
    {
        return $this->belongsToMany(Curso::class, 'cursos_docentes', 'docente_id', 'curso_id');
    }

    public function horarios()
    {
        return $this->hasMany(Horario::class, 'id_docente');
    }

    public function usuario()
    {
        return $this->belongsTo(Usuario::class, 'usuario_id');
    }
    public function getNombreCompletoAttribute()
{
    return "{$this->apellido}, {$this->nombre}";
}

        

}
