@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Listado de Convalidaciones @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button class="btn btn-outline-primary mb-3" data-bs-toggle="modal" data-bs-target="#modalReporte">
                    Generar reporte por fecha
                </button>
                <div class="table-responsive">
                    <table id="tablaPeriodos" class="table table-striped mb-0 table-hover">
                        <thead >
                            <tr>
                                <th>#</th>
                                <th>Estudiante</th>
                                <th>Curso Destino</th>
                                <th>Curso Origen</th>
                                <th>Institución Origen</th>
                                <th>Nota</th>
                                <th>Periodo</th>
                                <th>Fecha</th>
                                <th>Observaciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($convalidaciones as $item)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $item->estudiante->nombres ?? 'N/A' }} {{ $item->estudiante->apellidos ?? 'N/A' }}</td>
                                    <td>{{ $item->cursoDestino->nombre ?? 'N/A' }}</td>
                                    <td>{{ $item->curso_origen }}</td>
                                    <td>{{ $item->institucion_origen }}</td>
                                    <td>{{ $item->nota_origen }}</td>
                                    <td>{{ $item->periodo->nombre ?? 'N/A' }}</td>
                                    <td>{{ \Carbon\Carbon::parse($item->fecha_convalidacion)->format('d/m/Y') }}</td>
                                    <td>{{ $item->observaciones }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="text-center">No hay convalidaciones registradas.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>


<!--end row-->
<!-- Modal -->
<div class="modal fade" id="modalReporte" tabindex="-1" aria-labelledby="modalReporteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" action="{{ route('convalidaciones.reporte') }}" target="_blank" id="formReporteConvalidaciones">
        @csrf
        <div class="modal-content">
            <div class="modal-header">
            <h5 class="modal-title" id="modalReporteLabel">Reporte de Convalidaciones por Fecha</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
            <div class="mb-3">
                <label for="fecha_inicio" class="form-label">Fecha de inicio</label>
                <input type="date" name="fecha_inicio" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="fecha_fin" class="form-label">Fecha de fin</label>
                <input type="date" name="fecha_fin" class="form-control" required>
            </div>
            </div>
            <div class="modal-footer">
            <button type="submit" class="btn btn-success">Generar PDF</button>
            </div>
        </div>
    </form>
  </div>
</div>

@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaPeriodos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPeriodos_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
document.getElementById('formReporteConvalidaciones').addEventListener('submit', function(e) {
    e.preventDefault();

    const form = this;
    const fechaInicio = form.querySelector('[name="fecha_inicio"]').value;
    const fechaFin = form.querySelector('[name="fecha_fin"]').value;

    if (!fechaInicio || !fechaFin) {
        alert('Ambas fechas son obligatorias.');
        return;
    }

    // Crear un formulario en memoria y enviarlo
    const formData = new FormData(form);
    const url = form.action;

    const newWindow = window.open('', '_blank');

    fetch(url, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': form.querySelector('input[name="_token"]').value
        }
    })
    .then(res => res.blob())
    .then(blob => {
        const blobUrl = URL.createObjectURL(blob);
        newWindow.location.href = blobUrl;
    })
    .catch(() => {
        newWindow.close();
        alert('Error generando el PDF.');
    });

    // Cierra el modal
    bootstrap.Modal.getInstance(document.getElementById('modalReporte')).hide();
});
</script>


@endsection
