<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Oferta Laboral</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            line-height: 1.5;
            color: #000;
        }

        h1, h2, h3 {
            margin: 0;
            padding: 0;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .section {
            margin-bottom: 20px;
        }

        .section-title {
            background-color: #f2f2f2;
            padding: 5px;
            font-weight: bold;
            border-bottom: 1px solid #ccc;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        td, th {
            padding: 6px 8px;
            vertical-align: top;
        }

        .bordered td {
            border: 1px solid #ddd;
        }

        .small-text {
            font-size: 11px;
        }

        .label {
            font-weight: bold;
        }

    </style>
</head>
<body>

    <div class="header">
        <h2>OFERTA LABORAL</h2>
        <p><strong>{{ $oferta->titulo }}</strong></p>
    </div>

    {{-- DATOS BÁSICOS --}}
    <div class="section">
        <div class="section-title">Datos Básicos</div>
        <table>
            <tr>
                <td><span class="label">Título:</span></td>
                <td>{{ $oferta->titulo }}</td>
                <td><span class="label">Lugar:</span></td>
                <td>{{ $oferta->lugar ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td><span class="label">Empresa:</span></td>
                <td>{{ $oferta->empresa->nombre_empresa ?? 'N/A' }}</td>
                <td><span class="label">Tipo de Contrato:</span></td>
                <td>{{ $oferta->tipoContrato->nombre_tipo_contrato ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td><span class="label">Fecha de Publicación:</span></td>
                <td>{{ \Carbon\Carbon::parse($oferta->fecha_publicacion)->format('d/m/Y') }}</td>
                <td><span class="label">Fecha Límite:</span></td>
                <td>{{ \Carbon\Carbon::parse($oferta->fecha_limite)->format('d/m/Y') }}</td>
            </tr>
            <tr>
                <td><span class="label">Estado:</span></td>
                <td>{{ ucfirst($oferta->estado) }}</td>
                <td><span class="label">Vacantes:</span></td>
                <td>{{ $oferta->vacantes ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td><span class="label">Remuneración:</span></td>
                <td>{{ $oferta->remuneracion ? 'S/ ' . number_format($oferta->remuneracion, 2) : 'N/A' }}</td>
                <td><span class="label">Plan de Estudio:</span></td>
                <td>{{ $oferta->planEstudio->nombre ?? 'N/A' }}</td>
            </tr>
        </table>
    </div>

    {{-- DESCRIPCIÓN Y REQUISITOS --}}
    <div class="section">
        <div class="section-title">Descripción y Requisitos</div>
        <table class="bordered">
            <tr>
                <td><strong>Descripción:</strong><br>{{ $oferta->descripcion }}</td>
            </tr>
            @if ($oferta->experiencia)
            <tr>
                <td><strong>Experiencia Requerida:</strong><br>{{ $oferta->experiencia }}</td>
            </tr>
            @endif
            @if ($oferta->tipo_oferta)
            <tr>
                <td><strong>Tipo de Oferta:</strong><br>{{ $oferta->tipo_oferta }}</td>
            </tr>
            @endif
        </table>
    </div>

    {{-- PASOS PARA POSTULAR --}}
    @if ($oferta->pasos_postular)
    <div class="section">
        <div class="section-title">Pasos para Postular</div>
        <p>{{ $oferta->pasos_postular }}</p>
    </div>
    @endif

    {{-- ARCHIVO ADJUNTO --}}
    @if ($oferta->archivo_pdf)
    <div class="section">
        <div class="section-title">Archivo Adjunto</div>
        <p>Este documento tiene un archivo PDF adicional: <strong>{{ $oferta->archivo_pdf }}</strong></p>
        <p class="small-text">Puedes descargarlo desde el sistema.</p>
    </div>
    @endif

    <div class="section small-text">
        <hr>
        <p>Generado el {{ \Carbon\Carbon::now()->format('d/m/Y H:i') }}</p>
    </div>

</body>
</html>
