@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Pabellones @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalNuevoPabellon">
                    <i class="fas fa-plus"></i> Agregar Nuevo Pabellon
                </button>
                <div class="table-responsive">
                    <table id="tablaPabellon" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Descripción</th>
                                <th class="text-center">Acciones</th>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($pabellones as $pabellon)
                                <tr>
                                    <td>{{ $pabellon->id }}</td>
                                    <td>{{ $pabellon->nombre }}</td>
                                    <td>{{ $pabellon->descripcion ?? '-' }}</td>

                                    <td class="text-center">

                                        <!-- EDITAR -->
                                        <a href="#"
                                            class="text-warning btn-editar-pabellon"
                                            data-bs-toggle="modal"
                                            data-bs-target="#modalEditarPabellon"
                                            data-id="{{ $pabellon->id }}"
                                            data-nombre="{{ $pabellon->nombre }}"
                                            data-descripcion="{{ $pabellon->descripcion }}">
                                            <i class="las la-pen text-secondary font-18"></i>
                                        </a>


                                        <!-- ELIMINAR -->
                                        <a href="#"
                                        class="text-danger btn-eliminar-pabellon"
                                        data-id="{{ $pabellon->id }}">
                                            <i class="las la-trash-alt text-secondary font-18"></i>
                                        </a>

                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>



                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- MODAL NUEVO PABELLÓN -->
<div class="modal fade" id="modalNuevoPabellon" tabindex="-1" aria-labelledby="modalNuevoPabellonLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modalNuevoPabellonLabel">Registrar Nuevo Pabellón</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">

                <form id="formNuevoPabellon">
                    @csrf

                    <div class="mb-3">
                        <label class="form-label">Nombre del Pabellón</label>
                        <input type="text" name="nombre" class="form-control" required placeholder="Ej. Pabellón A">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Descripción (Opcional)</label>
                        <textarea name="descripcion" class="form-control" rows="3" placeholder="Descripción del pabellón"></textarea>
                    </div>

                </form>

            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    Cerrar
                </button>
                <button type="button" class="btn btn-de-primary" id="btnGuardarPabellon">
                    Guardar
                </button>
            </div>

        </div>
    </div>
</div>






<!-- Modal de Edición -->


<!-- MODAL EDITAR PABELLÓN -->
<div class="modal fade" id="modalEditarPabellon" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header bg-warning">
                <h5 class="modal-title">Editar Pabellón</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <form id="formEditarPabellon">

                @csrf
                @method('PUT')

                <input type="hidden" id="edit_id" name="id">

                <div class="modal-body">

                    <div class="mb-3">
                        <label class="form-label">Nombre</label>
                        <input type="text" id="edit_nombre" name="nombre" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Descripción</label>
                        <textarea id="edit_descripcion" name="descripcion" class="form-control" rows="3"></textarea>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-warning">Guardar Cambios</button>
                </div>

            </form>

        </div>
    </div>
</div>



<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaPabellon").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPabellon_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
    $(document).ready(function(){

        // === GUARDAR NUEVO PABELLÓN ===
        $('#btnGuardarPabellon').click(function () {

            let formData = new FormData($('#formNuevoPabellon')[0]);

            Swal.fire({
                title: "¿Registrar nuevo pabellón?",
                icon: "question",
                showCancelButton: true,
                confirmButtonText: "Sí, guardar",
                cancelButtonText: "Cancelar"
            }).then((result) => {

                if (result.isConfirmed) {

                    $.ajax({
                        url: "{{ route('pabellones.store') }}",
                        type: "POST",
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function (response) {

                            Swal.fire({
                                title: "Registrado",
                                text: "El pabellón fue registrado correctamente.",
                                icon: "success",
                                timer: 1500,
                                showConfirmButton: false
                            });

                            $('#modalNuevoPabellon').modal('hide');
                            $('#formNuevoPabellon')[0].reset();

                            // Recargar tabla
                            setTimeout(() => location.reload(), 800);
                        },

                        error: function (xhr) {
                            Swal.fire({
                                title: "Error",
                                text: xhr.responseJSON?.message || "No se pudo registrar el pabellón.",
                                icon: "error"
                            });
                        }

                    });

                }
            });

        });

    });
</script>

<script>
// Cargar datos en el modal al hacer clic en "Editar"
$(document).on('click', '.btn-editar-pabellon', function () {
    $('#edit_id').val($(this).data('id'));
    $('#edit_nombre').val($(this).data('nombre'));
    $('#edit_descripcion').val($(this).data('descripcion'));
});

// Guardar cambios vía AJAX
$('#formEditarPabellon').on('submit', function (e) {
    e.preventDefault();

    let id = $('#edit_id').val();
    let formData = new FormData(this);

    $.ajax({
        url: "/pabellones/" + id,
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },

        beforeSend: function () {
            Swal.fire({
                title: "Guardando...",
                text: "Por favor espere",
                allowOutsideClick: false,
                didOpen: () => Swal.showLoading()
            });
        },

        success: function (response) {
            Swal.close();

            if (response.success) {
                Swal.fire({
                    icon: "success",
                    title: "Actualizado",
                    text: response.message,
                    timer: 1500,
                    showConfirmButton: false
                });

                setTimeout(() => location.reload(), 1600);
            } else {
                Swal.fire("Error", response.message, "error");
            }
        },

        error: function () {
            Swal.close();
            Swal.fire("Error", "No se pudo actualizar el pabellón", "error");
        }
    });

});


</script>

<script>
$(document).on("click", ".btn-eliminar-pabellon", function (e) {
    e.preventDefault();

    let id = $(this).data("id");
    let fila = $(this).closest("tr"); // para eliminar la fila sin recargar

    Swal.fire({
        title: "¿Eliminar Pabellón?",
        text: "Esta acción no se puede deshacer.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#d33",
        cancelButtonColor: "#6c757d",
        confirmButtonText: "Sí, eliminar",
        cancelButtonText: "Cancelar"
    }).then((result) => {

        if (result.isConfirmed) {

            $.ajax({
                url: "/pabellones/" + id,
                type: "POST",
                data: {
                    _token: $('meta[name="csrf-token"]').attr("content"),
                    _method: "DELETE"
                },

                beforeSend: function () {
                    Swal.fire({
                        title: "Eliminando...",
                        allowOutsideClick: false,
                        didOpen: () => Swal.showLoading()
                    });
                },

                success: function (response) {
                    Swal.close();

                    if (response.success) {
                        Swal.fire({
                            icon: "success",
                            title: "Eliminado",
                            text: response.message,
                            timer: 1400,
                            showConfirmButton: false
                        });

                        // Animación para eliminar fila sin recargar
                        fila.fadeOut(600, function () {
                            $(this).remove();
                        });

                    } else {
                        Swal.fire("Error", response.message, "error");
                    }
                },

                error: function () {
                    Swal.close();
                    Swal.fire("Error", "No se pudo eliminar el pabellón", "error");
                }
            });

        }

    });
});
</script>


@endsection
